package edu.columbia.cs.itx.dsadmin.event;

import javax.swing.event.*;

public class AbstractDSAuthenticationModel extends Object implements DSAuthenticationModel {

  protected EventListenerList listenerList = new EventListenerList();

  public void addDSAuthenticationListener(DSAuthenticationListener l) {
    listenerList.add(DSAuthenticationListener.class, l);
  }

  public void removeDSAuthenticationListener(DSAuthenticationListener l) {
    listenerList.remove(DSAuthenticationListener.class, l);
  }

  public void fireAuthenticated(Object source) {
    Object[] listeners = listenerList.getListenerList();
    DSAuthenticationEvent e = null;

    for (int i = listeners.length - 2; i >= 0; i -= 2) {
	    if (listeners[i] == DSAuthenticationListener.class) {
	  	  if (e == null) {
		      e = new DSAuthenticationEvent(source);
		    }
		    ((DSAuthenticationListener)listeners[i+1]).dsAuthenticated(e);
      }
    }
  }
}

 